﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace Projekt
{
    public struct Angle
    {
        Double angle;

        #region constructors
        public Angle(Double angle)
        {
            this.angle = angle % (2.0 * Math.PI);
            if (this.angle < 0.0)
            {
                this.angle += 2.0 * Math.PI;
            }
        }

        //public Angle(Double x, Double y)
        //{
        //    this.angle = (Double)new Angle(Math.Atan(y / x));
        //}

        public Angle(Angle angle)
        {
            this.angle = angle.angle;
        }
        #endregion

        #region conversions
        public static Angle FromRad(double rad)
        {
            return new Angle(rad);
        }

        public static Angle FromDeg(double deg)
        {
            return new Angle(Math.PI * deg / 180.0);
        }

        public Double Deg
        {
            get { return 180.0 * angle / Math.PI; }
        }

        public Double Degpm
        {
            get { return Deg > 180 ? 360 - Deg : Deg; }
        }

        public Double Rad
        {
            get { return angle; }
        }

        public Double Radpm
        {
            get { return angle > Math.PI ? (Math.PI * 2.0 - angle ) : angle; }
        }
        #endregion

        #region trigonometry
        public Double cos()
        {
            return Math.Cos(angle);
        }

        public Double cos(Double length)
        {
            return Math.Cos(angle) * length;
        }

        public Double sin()
        {
            return Math.Sin(angle);
        }

        public Double sin(Double length)
        {
            return Math.Sin(angle) * length;
        }

        public Double tan()
        {
            return Math.Tan(angle);
        }
        #endregion

        #region operators
        public static implicit operator Angle(double value)
        {
            return new Angle(value);
        }

        public static explicit operator double(Angle value)
        {
            return value.angle;
        }

        public static Angle operator +(Angle firstAngle, Angle secondAngle)
        {
            return new Angle(firstAngle.angle + secondAngle.angle);
        }

        public static Angle operator -(Angle firstAngle, Angle secondAngle)
        {
            return new Angle(firstAngle.angle - secondAngle.angle);
        }

        public static Angle operator /(Angle Angle, Double div)
        {
            return new Angle(Angle.angle / div);
        }

        public static Angle operator *(Angle Angle, Double mult)
        {
            return new Angle(Angle.angle * mult);
        }

        public static Angle operator -(Angle angle)
        {
            return new Angle(-angle.angle);
        }

        public static Angle Max(Angle firstAngle, Angle secondAngle)
        {
            return new Angle(Math.Max(firstAngle.angle, secondAngle.angle));
        }

        public static Angle Min(Angle firstAngle, Angle secondAngle)
        {
            return new Angle(Math.Min(firstAngle.angle, secondAngle.angle));
        }
        #endregion
    }
}
