﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace Projekt
{
    public class DrivingWheel : IDrivingWheel
    {
        #region Constructors
        public DrivingWheel(IContext context, Double radius, WheelType type)
        {
            this.context = context;
            this.Radius = radius;
            this.Type = type;
        }
        #endregion

        #region Fixed Properties
        IContext context;
        public IContext Context
        { get { return context; } }

        Double radius;
        public double Radius
        {
            get { return radius; }
            private set
            {
                if (value > 0.0)
                {
                    radius = value;
                }
                else
                {
                    radius = 1.0;
                }
            }
        }

        public WheelType Type
        {
            get;
            private set;
        }
        #endregion

        #region Changing Properties
        public Coord Position
        {
            get;
            set;
        }

        public IGround Ground
        {
            get;
            set;
        }

        public Double Torque
        {
            get;
            set;
        }
        #endregion

        #region Methods
        public double GetForce(Double normalForce, Double velocity)
        {
            var ground = Ground as Ground;
            var friction = FrictionTableClass.Instance[ground.CurrentWeather, ground.CurrentGround, Type];
            if ((velocity * Torque).SignificantlySmallerZero())
            {
                return (-1.0) * normalForce * friction.FrictionCoeff * Math.Sign(velocity);
            }
            else
            {
                Double result = 0.0;
                if (Torque.SignificantlyGreaterZero())
                {
                    var force = Torque / Radius;
                    result += Math.Abs(force) < friction.FrictionCoeff * normalForce ? force : (force * 0.1); //magic number 0.1!
                }
                if (Torque.SignificantlySmallerZero())
                {
                    var force = Torque / Radius;
                    result += Math.Abs(force) < friction.FrictionCoeff * normalForce ? (force * 0.5) : (force * 0.1); //magic number 0.1 & 0.5!
                }
                if (velocity.SignificantlyNotZero())
                {
                    result -= friction.RollingFrictionCoeff * normalForce * Math.Sign(velocity);
                }
                return result;
            }
        }
        #endregion 
    }
}
