﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace Projekt
{
    public class Wheel : IDrivingWheel
    {
        #region Constructors 
        public Wheel(IContext context, Double radius, WheelType type)
        {
            this.context = context;
            this.Radius = radius;
            this.Type = type;
        }
        #endregion

        #region Fixed Properties
        IContext context;
        public IContext Context
        { get { return context; } }

        private Double radius;
        public Double Radius
        {
            get { return radius; }
            private set
            {
                if (value > 0.0)
                {
                    radius = value;
                }
                else
                {
                    radius = 1.0;
                }
            }
        }

        public WheelType Type
        {
            get;
            private set;
        }
        #endregion

        #region Changing Properties
        public Coord Position
        {
            get;
            set;
        }

        public IGround Ground
        {
            get;
            set;
        }

        public Double Torque
        {
            get;
            set;
        }
        #endregion

        #region Methods
        public double GetForce(Double normalForce, Double velocity)
        {
            var ground = Ground as Ground;
            var friction = FrictionTableClass.Instance[ground.CurrentWeather, ground.CurrentGround, Type];

            if (Torque.SignificantlyNotZero() && velocity.SignificantlyNotZero())
            {
                return (-1.0) * normalForce * friction.FrictionCoeff * Math.Sign(velocity);
            }
            else if (velocity.SignificantlyNotZero())
            {
                return (-1.0) * normalForce * friction.RollingFrictionCoeff * Math.Sign(velocity);
            }
            else
            {
                return 0.0;                
            }
        }
        #endregion
    }
}
