﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace Projekt
{
    public class RWDCar : Car
    {
        /// <summary>
        /// Instanciates a rear wheel drive car
        /// </summary>
        /// <param name="context">overall context</param>
        /// <param name="mass">mass of the car</param>
        /// <param name="length">length of the car</param>
        /// <param name="width">width of the car</param>
        /// <param name="centerOfMassHorizontal">horizontal distance from the rear axle to the center of mass of the car</param>
        /// <param name="position">position of the car</param>
        /// <param name="wheelRadius">radius of the wheels of the car</param>
        /// <param name="maxAngle">maximal angle of the steering wheels</param>
        /// <param name="wheelType">type of the wheels</param>
        /// <param name="dragCoefficient">drag coefficient of the car (typically between 0.1 and 0.5)</param>
        /// <param name="maxPower">maximal power of the engine of the vehicle</param>
        public RWDCar(IContext context, Double mass, Double length, Double width, Double centerOfMassHorizontal, Placement position, Double wheelRadius, Angle maxAngle, WheelType wheelType, Double dragCoefficient, Power maxPower)
        {
            this.context = context;
            this.CenterOfMassHorizontal = centerOfMassHorizontal;
            this.Length = length;
            this.Width = width;
            this.Mass = mass;
            this.Position = position;
            this.Velocity = 0.0;
            this.WheelNumber = 4;
            this.DragCoefficient = dragCoefficient;
            this.MaxPower = maxPower;
            
            frontLeft = new SteeringWheel(context, wheelRadius, wheelType, maxAngle);
            frontRight = new SteeringWheel(context, wheelRadius, wheelType, maxAngle);
            rearLeft = new DrivingWheel(context, wheelRadius, wheelType);
            rearRight = new DrivingWheel(context, wheelRadius, wheelType);

            //testzwecke
            frontLeft.Ground = new Ground 
            {
                CurrentGround = GroundType.Asphalt,
                CurrentWeather = GroundCondition.Dry
            };
            frontRight.Ground = new Ground
            {
                CurrentGround = GroundType.Asphalt,
                CurrentWeather = GroundCondition.Dry
            };
            rearLeft.Ground = new Ground
            {
                CurrentGround = GroundType.Asphalt,
                CurrentWeather = GroundCondition.Dry
            };
            rearRight.Ground = new Ground
            {
                CurrentGround = GroundType.Asphalt,
                CurrentWeather = GroundCondition.Dry
            };
        }

        public override void ApplyTorque()
        {
            RearLeft.Torque = CurrentPower.Watt * RearLeft.Radius / (2.0 * (500.0 * RearLeft.Radius + Velocity)); //magic number 1000.0 (min number of revolutions / s)
            RearRight.Torque = CurrentPower.Watt * RearRight.Radius / (2.0 * (500.0 * RearRight.Radius + Velocity)); //magic number 1000.0 (min number of revolutions / s)

            if ((CurrentPower.Watt * Velocity).SignificantlySmallerZero())
            {
                FrontLeft.Torque = CurrentPower.Watt * FrontLeft.Radius / (2.0 * (500.0 * FrontLeft.Radius + Velocity)); //magic number 1000.0 (min number of revolutions / s)
                FrontRight.Torque = CurrentPower.Watt * FrontRight.Radius / (2.0 * (500.0 * FrontRight.Radius + Velocity)); //magic number 1000.0 (min number of revolutions / s)
            }
            else
            {
                FrontLeft.Torque = 0.0;
                frontRight.Torque = 0.0;
            }
        }

        public override void ApplyAngle(Angle angle)
        {
            FrontLeft.CurrentAngle = angle;
            FrontRight.CurrentAngle = angle;
        } 
    }
}
