﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Drawing;
using System.Data;
using System.Linq;
using System.Text;
using System.Windows.Forms;
using MovieToolForms.GUI.Components;
using System.IO;
using System.Threading;
using System.Threading.Tasks;
using MovieToolForms.Logic;
using MovieToolForms.Model;
using System.Diagnostics;
using DbManager;
using MovieToolForms.GUI.Content;

namespace MovieToolForms.GUI.Content
{
    public partial class Scanner : UCListener
    {

        List<HardDisk> diskList = new List<HardDisk>();

        public Scanner()
        {
            InitializeComponent();
            fillDiskList();
            fillDiskBox();
        }

        public void fillDiskList() {

            DriveInfo[] drives = DriveInfo.GetDrives();

            foreach (DriveInfo drive in drives)
            {
                if (drive.IsReady)
                    diskList.Add(new HardDisk(drive.VolumeLabel, drive.RootDirectory.FullName, drive.TotalFreeSpace, drive.TotalSize));
            }
        }

        public void fillDiskBox() {
            int positionCounter = 1;
            int temp;
            grpHd.Controls.Clear();
            foreach (HardDisk disk in diskList) {
                grpHd.Controls.Add(disk);

                temp = Convert.ToInt32((disk.Height * positionCounter)*1.2);
                disk.Location = new Point(5, temp);
                positionCounter++;
            }
        
        }

        private void button1_Click(object sender, EventArgs e)
        {

            HDScanner scanner = new HDScanner();
            Task scanHds = new Task(delegate { scanner.ScannSelectedHDs(diskList); });
            scanHds.Start();

         //   DBMovieLogic dbl = new DBMovieLogic();

            



        }



        public override void refreshControl()
        {
            
        }
    }
}
