﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Drawing;
using System.Data;
using System.Linq;
using System.Text;
using System.Windows.Forms;

namespace MovieToolForms.GUI
{
    public partial class NavHeading : UserControl
    {
        private NavArea parent;
        private MenuPart parentMenuPart;

        private NavHeading()
        {
            InitializeComponent();
            initEvents();
        }
      
        public NavHeading(String heading, NavArea parent, Bitmap icon) : this()
        {
            txtHeading.Text = heading;
            this.parent = parent;
            iconBox.Image = icon;
        }

        private void initEvents()
        {
            foreach (Control control in this.Controls) {
                control.Click += new EventHandler(control_Click);
                control.MouseEnter += new EventHandler(control_MouseEnter);
                control.MouseHover += new EventHandler(control_MouseEnter);
                control.MouseLeave += new EventHandler(control_MouseLeave);
            }
        }

        void control_MouseLeave(object sender, EventArgs e)
        {
            if (this.BackColor == Color.Transparent)
                return;

            this.BackColor = Color.Transparent;
            this.Refresh();
        }


        // ------------ Hover Event
        void control_MouseEnter(object sender, EventArgs e)
        {
            if (this.BackColor == Color.White)
                return;

            this.BackColor = Color.White;
            this.Refresh();
        }

        // ------------- Click Event
        void control_Click(object sender, EventArgs e)
        {
            parent.receiveHeadingClick(this);
        }


        public MenuPart ParentMenuPart
        {
            get { return parentMenuPart; }
            set { parentMenuPart = value; }
        }

        public PictureBox ToggleBox {
            get { return picToggleItem; }
        }

    }
}
