﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Drawing;
using System.Data;
using System.Linq;
using System.Text;
using System.Windows.Forms;
using System.Threading;

namespace MovieToolForms.GUI.Components
{
    public partial class HardDisk : UserControl
    {
        private bool isActive = false;
        private bool isScanned = false;
        private int directoryCount = 0;
        private string label;
        private string root;
        private string totalSize;
        private string percentage;
        private int barValue;

        SynchronizationContext syncContext;

        private HardDisk()
        {
            InitializeComponent();
            syncContext = SynchronizationContext.Current;
        }

        private void syncUpdate(object o) {
            progressScan.Value = progressScan.Maximum;
            BorderStyle = BorderStyle.FixedSingle;
            this.BackColor = SystemColors.Control;
            picStatus.Image = global::MovieTool.Properties.Resources.okButton30;
            
            

        }

        public void scanDone() {

            isScanned = true;
            syncContext.Send(syncUpdate, null);
        }

        public HardDisk(String label, String root, long freeSpace, long totalSize) :this() {
            
            this.totalSize = BytesToString(freeSpace, false) + "/" + BytesToString(totalSize, true);
            double percent = (((double)freeSpace / (double)totalSize) * 100);
            percentage = ((int)percent).ToString() + "%";
            barValue = 100 - ((int)percent);

            if (barValue > 80)
                barFreeSpace.ForeColor = Color.Orange;

            if (barValue > 90)
                barFreeSpace.ForeColor = Color.Crimson;

            barFreeSpace.Style = ProgressBarStyle.Continuous;
           
            this.label = label;
            this.root = root;

            refreshView();
            addListeners();
        }

        private void addListeners()
        {
            foreach (Control control in Controls) {
                if(control != picStatus)
                control.Click += new EventHandler(control_Click);
            }
            this.Click += new EventHandler(control_Click);
        }


        void control_Click(object sender, EventArgs e)
        {
            if (isScanned)
                return;

            if (BorderStyle == BorderStyle.FixedSingle)
            {
                this.BackColor = Color.Honeydew;
                BorderStyle = BorderStyle.Fixed3D;
                isActive = true;
            }
            else
            {
                this.BackColor = SystemColors.Control;
                BorderStyle = BorderStyle.FixedSingle;
                isActive = false;
            }
        }

        private void toggleHdButton() { 
            
                    
        }

        public void updateScanProgress() {
            if (directoryCount == 0)
                return;
            syncContext.Send(delegate { setProgressbarValue(); }, null);
            
        }

        private void setProgressbarValue()
        {
            if (progressScan.Maximum == progressScan.Value)
                return;

            progressScan.Value += 1;
            directoryCount--;
        }

        private void refreshView()
        {
            txtLetter.Text = label;
            txtPath.Text = root;
            txtFreeSpace.Text = totalSize;
            txtPercentage.Text = percentage;
            barFreeSpace.Value = barValue;

            this.Refresh();
        }

        static String BytesToString(long byteCount, bool full)
        {
            string[] suf = { "B", "KB", "MB", "GB", "TB", "PB", "EB" };
            if (byteCount == 0)
                return "0" + suf[0];
            long bytes = Math.Abs(byteCount);
            int place = Convert.ToInt32(Math.Floor(Math.Log(bytes, 1024)));
            double num = Math.Round(bytes / Math.Pow(1024, place), 1);
            if (full)
                return (Math.Sign(byteCount) * num).ToString() + "" + suf[place];
            else
                return (Math.Sign(byteCount) * num).ToString();
        }

        public void setLetter(String letter) {
            txtLetter.Text = letter;
        }

        public void setPath(String path) {
            txtPath.Text = path;
        }

        public void setSpace(String space) {
            txtFreeSpace.Text = space;
        }


        private void initScanBar(int val) {
            progressScan.Maximum = val;
        }


        public int DirectoryCount
        {
            get { return directoryCount; }
            set
            {
                directoryCount = value + Convert.ToInt32(value *0.1);
            syncContext.Send(delegate { initScanBar(value); }, null);
            }
        }
        public bool IsActive
        {
            get { return isActive; }
            set { isActive = value; }
        }

        public string Root
        {
            get { return root; }
            set { root = value; }
        }


        public bool IsScanned
        {
            get { return isScanned; }
            set { isScanned = value; }
        }

        private void button1_Click(object sender, EventArgs e)
        {
            isScanned = false;
            picStatus.Image = null;
            progressScan.Value = progressScan.Minimum;
        }
    }
}
