﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Drawing;
using System.Data;
using System.Linq;
using System.Text;
using System.Windows.Forms;
using MovieToolForms.GUI.Content;

namespace MovieToolForms.GUI
{
    public partial class NavEntry : UserControl
    {
        private bool isActive = false;
        private UCListener contentControl;
        private NavArea parent;


        private NavEntry()
        {
            InitializeComponent();
            initEvents();
        }

        public NavEntry(String content, UCListener contentControl, NavArea parent)
            : this()
        {
            txtContent.Text = content;
            this.contentControl = contentControl;
            this.parent = parent;
        }


        private void initEvents()
        {
            foreach (Control control in this.Controls)
            {
                control.Click += new EventHandler(control_Click);
                control.MouseEnter += new EventHandler(control_MouseHover);
                control.MouseHover += new EventHandler(control_MouseHover);
                control.MouseLeave += new EventHandler(control_MouseLeave);
            }
        }

        void control_MouseLeave(object sender, EventArgs e)
        {
            if (txtContent.ForeColor == Color.RoyalBlue)
                return;

            if (IsActive)
                return;

            txtContent.ForeColor = Color.RoyalBlue;
            this.Refresh();
        }

        void control_MouseHover(object sender, EventArgs e)
        {
            if (txtContent.ForeColor == Color.Crimson)
                return;

            txtContent.ForeColor = Color.Crimson;
            this.Refresh();
        }


        void control_Click(object sender, EventArgs e)
        {
            this.isActive = true;
            parent.receiveEntryClick(this);
            contentControl.refreshControl();
        }


        public void activateEntry() {
            txtContent.ForeColor = Color.Crimson;
        }

        public void deactivateEntry() {
            txtContent.ForeColor = Color.RoyalBlue;
        }

        public Label ContentText {
            get { return txtContent; }
        }

        public bool IsActive
        {
            get { return isActive; }
            set { isActive = value; }
        }

        public UCListener ContentControl
        {
            get { return contentControl; }
            set { contentControl = value; }
        }

       
    }
}
