﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;
using System.Xml.Serialization;
using System.IO;

namespace MyCSharpProject
{
    public partial class Form1 : Form
    {
        int sp;
        MyGame newgame;
        public List<MyQuestion> questions{get;set;}
        

        public Form1()
        {
            InitializeComponent();
            
            
            
        }

        
        /// <summary>
        /// OPENS THE SETTINGS FORM
        /// DEPENDENT ON THE NUMBER OF PLAYERS IT SHOWS THE MYPLAYERCONTROLS IN MYFIELDCONTROL
        /// ALSO IT DESERIALIZES THE QUESTIONS FROM A SELECTED XML QUESTION FILE
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void newGame_Click(object sender, EventArgs e)
        {
            myFieldControl1.Restart();
            var s = new Settings(this);
            s.ShowDialog();
            sp = s.Spielerzahl;

            for (int i = 0; i < 4; i++)
                if (i < sp)
                {
                    myFieldControl1.Players[i].Show();
                    myFieldControl1.ShowMyPicture(i);
                }
                else
                {
                    myFieldControl1.Players[i].Hide();
                    myFieldControl1.HideMyPicture(i);
                }
        
            XmlSerializer xml = new XmlSerializer(typeof(List<MyQuestion>));
            string filename = s.QuestionFileName;
            try
            {
                using (var fs = new FileStream(filename, FileMode.Open))
                {
                    questions = xml.Deserialize(fs) as List<MyQuestion>;
                }
            }
            catch
            {
                MessageBox.Show("The given file " + filename + " did not contain questions in the correct format!");
                questions = new List<MyQuestion>();
                questions.Add(new MyQuestion { Category = MyCategory.Architektur, Question = "?1", RightAnswer = "D", WrongAnswerA = "A", WrongAnswerB = "B", WrongAnswerC = "C" });
                questions.Add(new MyQuestion { Category = MyCategory.Brauchtum, Question = "?2", RightAnswer = "D", WrongAnswerA = "A", WrongAnswerB = "B", WrongAnswerC = "C" });

                using (var fs = new FileStream(filename, FileMode.Create))
                {
                    xml.Serialize(fs, questions);
                }
            }

            //NEW GAME STARTED AND SEND TO MYFIELDCONTROL
            newgame = new MyGame(questions);
            newgame.NoOfPlayers = sp;
            myFieldControl1.sendGame(newgame);

            myFieldControl1.SetRules("Press the Categories-Button");

            
        }

        
        

        
    }
}
