﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Drawing;
using System.Data;
using System.Linq;
using System.Text;
using System.Windows.Forms;
using System.Threading;

namespace MyCSharpProject
{
    public partial class MyPositionControl : UserControl
    {
        int[] playerPosition;
        int playerWidth = 50;
        int playerHeight;
        Brush[] playerBrushes;
        List<Image> playerImages;

        public event EventHandler<MyPositionEventArgs> GameEnds;

        public MyPositionControl()
        {
            InitializeComponent();
            playerPosition = new int[4] { 0, 0, 0, 0 };
            playerBrushes = new Brush[4] {Brushes.Red, Brushes.LightGreen, Brushes.LightSkyBlue, Brushes.Yellow};
            playerHeight = this.Height / 5;
            playerImages = new List<Image>() { myRessources.Red, myRessources.Green, myRessources.Blue, myRessources.yellow };
           
        }
                
        /// <summary>
        /// MOVES THE BRUSH OF THE CURRENT PLAYER (DEPENDING ON THE CURRENT CATEGORY NUMBER)
        /// </summary>
        /// <param name="PlayerNumber">CURRENT PLAYER NUMBER</param>
        /// <param name="QuestionNumber">CURRENT CATEGORY NUMBER</param>
        public void PlayerMove(int PlayerNumber, int CategoryNumber)
        {
            playerPosition[PlayerNumber] += playerWidth * (CategoryNumber + 1);

            //IF A PLAYER REACHES THE END, THE GAME ENDS
            if (playerPosition[PlayerNumber] > Width)
            {
                if (GameEnds != null)
                    GameEnds(this, new MyPositionEventArgs(true));
                
                for (int i = 0; i < 4; i++)
                {
                    playerPosition[i] = 0;
                }
               
                
            }
            
            Invalidate();
        }
                
        /// <summary>
        /// UPDATES THE FIELD
        /// </summary>
        /// <param name="e"></param>
        protected override void OnPaint(PaintEventArgs e)
        {
            var g = e.Graphics;
            g.DrawImage(myRessources.field_background, 0, 0, this.Width, this.Height);                //g.Clear(Color.ForestGreen);
            for (int i = 0; i < 16; i++)
            {
                for (int j = 0; j < 4; j++)
                {
                    g.DrawRectangle(Pens.Cyan, i * playerWidth, j * playerHeight, playerWidth, playerHeight);
                }
            }
            

            for (int i = 0; i < 4; i++)
                g.DrawImage(playerImages[i], playerPosition[i], i * playerHeight, playerWidth, playerHeight); 
            
                //NOT USED:
                //g.FillRectangle(playerBrushes[i], playerPosition[i], i * playerHeight, playerWidth, playerHeight);
            
        }
    }
}
