﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;

namespace MyCSharpProject
{
    public partial class Settings : Form
    {
        private Form1 parent;
        List<TextBox> NameBoxes;
        List<Label> LabelList;

        public Settings(Form1 parent)
        {
            InitializeComponent();
            this.parent = parent;
            NameBoxes = new List<TextBox>() { textBox1, textBox2, textBox3, textBox4};
            LabelList = new List<Label>() {label1, label2, label3, label4};


        }
                
        /// <summary>
        /// WHEN OK BUTTON IS CLICKED, IT COPIES THE PLAYER NAMES IN THE MYPLAYERCONTROL LABELS AND ENABLES MYFIELDCONTROL
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void buttonOk_Click(object sender, EventArgs e)
        {
            for (int i = 0; i < 4; i++)
            {
                parent.myFieldControl1.Players[i].Name = NameBoxes[i].Text;
            }
            
            parent.myFieldControl1.Enabled = true;
            
            this.Close();

        }

        
        /// <summary>
        /// PROPERTY FOR NUMBER OF PLAYERS
        /// </summary>
        public int Spielerzahl
        {
            get
            {
                return (int)numericUpDown1.Value;
            }
        }
                
        /// <summary>
        /// WHEN NUMBER OF PLAYERS IN NUMBERIC_UP_DOWN IS CHANGED, THE VISIBILITY OF THE LABELS AND TEXTBOX CHANGES
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void numericUpDown1_ValueChanged(object sender, EventArgs e)
        {
           for (int i = 0; i < 4; i++)
                    if (i < numericUpDown1.Value)
                    {
                        LabelList[i].Visible = true;
                        NameBoxes[i].Visible = true;
                    }
                    else
                    {
                        LabelList[i].Visible = false;
                        NameBoxes[i].Visible = false;
                    }

            
                
        }
               
        /// <summary>
        /// DIALOG TO OPEN A QUESTIONS FILE
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void button1_Click(object sender, EventArgs e)
        {
            var ofd = new OpenFileDialog();
            if (ofd.ShowDialog() == System.Windows.Forms.DialogResult.OK)
                textBox5.Text = ofd.FileName;
        }

        
        /// <summary>
        /// PROPERTY FOR THE FILENAME IN TEXTBOX FOR FILESTREAM
        /// </summary>
        public string QuestionFileName
        {
            get { return textBox5.Text; }
            set { textBox5.Text = value; }
        }
        
    }
}
