﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace MyCSharpProject
{
    class MyGame
    {
        Random rnd;
        public List<MyQuestion> QuestionCataloque { get; set; }
        public List<List<MyCategory>> PlayerXCategoryY { get; set; }
        public int NoOfPlayers { get; set; }
        public int CurrentlyOperatingPlayer { get; set; }
        public int CurrentCategoryNumber { get; set; }

        public event EventHandler<MyCategoryEventArgs> NewCategories;

        
        public MyGame(List<MyQuestion> lq)
        {
            PlayerNames = new string[] { "Spieler 1", "Spieler 2", "Spieler 3", "Spieler 4" };

            rnd = new Random();
            QuestionCataloque = lq;
            CurrentlyOperatingPlayer = 0;
            CurrentCategoryNumber = 0;

            //LOADS THE CATEGORIES WITH DUMMIES
            PlayerXCategoryY = new List<List<MyCategory>>();
            PlayerXCategoryY.Add(new List<MyCategory> { MyCategory.Architektur, MyCategory.Architektur, MyCategory.Architektur, MyCategory.Architektur });
            PlayerXCategoryY.Add(new List<MyCategory> { MyCategory.Architektur, MyCategory.Architektur, MyCategory.Architektur, MyCategory.Architektur });
            PlayerXCategoryY.Add(new List<MyCategory> { MyCategory.Architektur, MyCategory.Architektur, MyCategory.Architektur, MyCategory.Architektur });
            PlayerXCategoryY.Add(new List<MyCategory> { MyCategory.Architektur, MyCategory.Architektur, MyCategory.Architektur, MyCategory.Architektur });
          
        }

        
        
        /// <summary>
        /// RETURNS A RANDOM QUESTION FROM A CATEGORY FROM THE XML QUESTION FILE
        /// </summary>
        /// <returns>QUESTION</returns>
        public MyQuestion getCurrentQuestion()
        {
            
            var currentquestion = QuestionCataloque.Where(question => question.Category == PlayerXCategoryY[CurrentlyOperatingPlayer][CurrentCategoryNumber])
                .OrderBy(m => { return rnd.Next(100); }).FirstOrDefault();
            QuestionCataloque.Remove(currentquestion);

            return currentquestion;
        }

       
        /// <summary>
        /// MOVES TO THE NEXT PLAYER IN LINE
        /// </summary>
        public void NextPlayer()
        {
            CurrentlyOperatingPlayer++;
            if (CurrentlyOperatingPlayer >= NoOfPlayers)
            {
                CurrentlyOperatingPlayer = 0;
                CurrentCategoryNumber++;
                if (CurrentCategoryNumber >= 4)
                {
                    CurrentCategoryNumber = 0;

                    
                    if (NewCategories != null)
                    NewCategories(this, new MyCategoryEventArgs(true));
                    
                }
            }
        }

        
        /// <summary>
        /// PROPERTY TO GET THE PLAYERNAMES
        /// </summary>
        public string[] PlayerNames { get; set; }

    }

}
