﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows.Input;

namespace Downloader.ViewModels
{
    class RelayCommand : ICommand
    {
        Action<Object> execute;
        Predicate<Object> canExecute;

        public event EventHandler CanExecuteChanged;

        public RelayCommand(Action<Object> execute)
        {
            this.execute = execute;
            this.canExecute = _ => true;
        }

        public RelayCommand(Action<Object> execute, Predicate<Object> canExecute)
        {
            this.execute = execute;
            this.canExecute = canExecute;
        }

        public Boolean CanExecute(Object parameter)
        {
            return canExecute(parameter);
        }

        public void Execute(Object parameter)
        {
            execute(parameter);
        }
    }
}
