﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;
using Teilchenkollision.Properties;

namespace Teilchenkollision
{
    public partial class Form1 : Form
    {
        Pen pen1 = new Pen(Color.Black, 2.0f);
        Pen pen2 = new Pen(Color.Blue, 10.0f);
        Pen pen3 = new Pen(Color.Orange, 10.0f);
        Pen pen4 = new Pen(Color.Red, 10.0f);
        Pen pen5 = new Pen(Color.Green, 10.0f);
        
        Teilchen T1 = new Teilchen();
        Teilchen T2 = new Teilchen();
        Teilchen T3 = new Teilchen();
        Teilchen T4 = new Teilchen();

        double spenergie;
        double spenergie2;
        
        public Form1()
        {
            InitializeComponent();
            numericUpDown2.Value = 180;
            comboBox1.SelectedItem = comboBox1.Items[0];
            comboBox2.SelectedItem = comboBox2.Items[0];
            comboBox4.SelectedItem = comboBox4.Items[0];

            drawkollision();

        }

        private void numericUpDown1_ValueChanged(object sender, EventArgs e)
        {
            T1.winkel = numericUpDown1.Value;
            drawkollision();
        }

        private void numericUpDown2_ValueChanged(object sender, EventArgs e)
        {

            T2.winkel = numericUpDown2.Value;
            drawkollision();
        }

        private void numericUpDown4_ValueChanged(object sender, EventArgs e)
        {
            T3.winkel = numericUpDown4.Value;
            //drawexplosion();
        }

        private void comboBox1_SelectedValueChanged(object sender, EventArgs e)
        {
            if (comboBox1.SelectedItem.ToString() == "beliebiges Teilchen")
            {
                textBox1.Enabled = true;
                textBox1.Text = "";
            }
            else
            {
                textBox1.Enabled = false;
                textBox1.Text = getmasse(comboBox1.SelectedItem.ToString()).ToString();

            }

        }

        private void comboBox2_SelectedValueChanged(object sender, EventArgs e)
        {
            if (comboBox2.SelectedItem.ToString() == "beliebiges Teilchen")
            {
                textBox3.Enabled = true;
                textBox3.Text = "";
            }
            else
            {
                textBox3.Enabled = false;
                textBox3.Text = getmasse(comboBox2.SelectedItem.ToString()).ToString();
            }
        }

        private void comboBox4_SelectedValueChanged(object sender, EventArgs e)
        {
            if (comboBox4.SelectedItem.ToString() == "beliebiges Teilchen")
            {
                textBox8.Enabled = true;
                textBox8.Text = "";
            }
            else
            {
                textBox8.Enabled = false;
                textBox8.Text = getmasse(comboBox4.SelectedItem.ToString()).ToString();
            }
        }

        private void button1_Click(object sender, EventArgs e)
        {
            bool parse1 = double.TryParse(textBox1.Text, out T1.ruheenergie);
            bool parse2 = double.TryParse(textBox2.Text, out T1.kinenergie);
            T1.winkel = numericUpDown1.Value;

            bool parse3 = double.TryParse(textBox3.Text, out T2.ruheenergie);
            bool parse4 = double.TryParse(textBox4.Text,out T2.kinenergie);
            T2.winkel = numericUpDown2.Value;

            if (parse1 == false || parse2 == false || parse3 == false || parse4 == false)
            {
                MessageBox.Show("Bitte korrekte Zahlenwerte angeben");
            }

            else
            {
                textBox1.Enabled = false;
                textBox2.Enabled = false;
                textBox3.Enabled = false;
                textBox4.Enabled = false;
                numericUpDown1.Enabled = false;
                numericUpDown2.Enabled = false;
                comboBox1.Enabled = false;
                comboBox2.Enabled = false;
                button3.Visible = true;
                button1.Visible = false;
                panel5.Visible = false;
                label33.Visible = true;
                label34.Visible = true;
                label15.Visible = true;
                
                kollision();
                drawkollision();
                panel4.Visible = true;
                label15.Text = spenergie.ToString();
            }
        }
        private void button3_Click(object sender, EventArgs e)
        {
            if (comboBox1.SelectedItem.ToString() == "beliebiges Teilchen")
                textBox1.Enabled = true;
            textBox2.Enabled = true;
            if (comboBox2.SelectedItem.ToString() == "beliebiges Teilchen")
                textBox3.Enabled = true;
            textBox4.Enabled = true;
            numericUpDown1.Enabled = true;
            numericUpDown2.Enabled = true;
            comboBox1.Enabled = true;
            comboBox2.Enabled = true;
            button3.Visible = false;
            button1.Visible = true;
            pictureBox2.Visible = false;
            label38.Visible = false;
            label37.Visible = false;
            panel4.Visible = false;
            panel5.Visible = false;
            label33.Visible = false;
            label34.Visible = false;
            label15.Visible = false;
        }
        private void button2_Click(object sender, EventArgs e)
        {            
            bool parse5 = double.TryParse(textBox8.Text, out T3.ruheenergie);
            bool parse6 = double.TryParse(textBox7.Text, out T3.kinenergie);
            T3.winkel = numericUpDown4.Value;

            if (parse5 == false || parse6 == false)
            {
                MessageBox.Show("Bitte korrekte Zahlenwerte angeben");
            }
            else
            {
                textBox7.Enabled = false;
                textBox8.Enabled = false;
                numericUpDown4.Enabled = false;
                comboBox4.Enabled = false;
                button4.Visible = true;
                button2.Visible = false;
                panel5.Visible = true;

                explosion();
                drawexplosion();
                label30.Text = T4.ruheenergie.ToString();
                label31.Text = T4.kinenergie.ToString();
                label32.Text = T4.winkel.ToString();
                //label15.Text = spenergie.ToString();
                //label41.Text = spenergie2.ToString();
            }

        }
        private void button4_Click(object sender, EventArgs e)
        {
            textBox7.Enabled = true;
            if (comboBox4.SelectedItem.ToString() == "beliebiges Teilchen")
                textBox8.Enabled = true;
            numericUpDown4.Enabled = true;
            comboBox4.Enabled = true;
            button4.Visible = false;
            button2.Visible = true;
            pictureBox2.Visible = false;
            label38.Visible = false;
            label37.Visible = false;
            panel5.Visible = false;
        }


        private void kollision()
        {
            T1.v = Math.Sqrt(1 - Math.Pow(T1.ruheenergie / (T1.ruheenergie + T1.kinenergie), 2.0));
            T2.v = Math.Sqrt(1 - Math.Pow(T2.ruheenergie / (T2.ruheenergie + T2.kinenergie), 2.0));
            T1.energie = T1.ruheenergie / Math.Sqrt(1 - Math.Pow(T1.v, 2.0));
            T2.energie = T2.ruheenergie / Math.Sqrt(1 - Math.Pow(T2.v, 2.0));
            T1.px = Math.Cos((double)T1.winkel * Math.PI / 180.0) * (T1.ruheenergie * T1.v) / Math.Sqrt(1 - Math.Pow(T1.v, 2.0));
            T2.px = Math.Cos((double)T2.winkel * Math.PI / 180.0) * (T2.ruheenergie * T2.v) / Math.Sqrt(1 - Math.Pow(T2.v, 2.0));
            T1.py = Math.Sin((double)T1.winkel * Math.PI / 180.0) * (T1.ruheenergie * T1.v) / Math.Sqrt(1 - Math.Pow(T1.v, 2.0));
            T2.py = Math.Sin((double)T2.winkel * Math.PI / 180.0) * (T2.ruheenergie * T2.v) / Math.Sqrt(1 - Math.Pow(T2.v, 2.0));
            spenergie = Math.Sqrt(Math.Pow(T1.energie + T2.energie , 2.0) - Math.Pow(T1.px + T2.px , 2.0) - Math.Pow(T1.py + T2.py, 2.0));
        }

        private void explosion()
        {
            T3.v = Math.Sqrt(1 - Math.Pow(T3.ruheenergie / (T3.ruheenergie + T3.kinenergie), 2.0));
            T3.energie = T3.ruheenergie / Math.Sqrt(1 - Math.Pow(T3.v, 2.0));
            T3.px = Math.Cos((double)T3.winkel * Math.PI / 180.0) * (T3.ruheenergie * T3.v) / Math.Sqrt(1 - Math.Pow(T3.v, 2.0));
            T3.py = Math.Sin((double)T3.winkel * Math.PI / 180.0) * (T3.ruheenergie * T3.v) / Math.Sqrt(1 - Math.Pow(T3.v, 2.0));

            T4.energie = T1.energie + T2.energie - T3.energie;
            T4.px = T1.px + T2.px - T3.px;
            T4.py = T1.py + T2.py - T3.py;
            T4.impuls = Math.Sqrt(T4.px*T4.px + T4.py*T4.py);

            if ( T4.px >= 0 )
                T4.winkel = (decimal)(Math.Atan(T4.py / T4.px) * (double)180 / Math.PI);
            else
                T4.winkel = (decimal)((Math.Atan(T4.py / T4.px) * (double)180 / Math.PI) + 180);

            T4.ruheenergie = Math.Sqrt(Math.Pow(T4.energie, 2.0)-Math.Pow(T4.impuls, 2.0));
            T4.kinenergie = T4.energie - T4.ruheenergie;
            //T4.kinenergie = Math.Pow(T4.ruheenergie,2.0)/Math.Sqrt(1-Math.Pow(T4.v, 2.0));

            spenergie2 = Math.Sqrt(Math.Pow(T3.energie + T4.energie, 2.0) - Math.Pow(T3.px + T4.px, 2.0) - Math.Pow(T3.py + T4.py, 2.0));
        }

        private void drawkollision()
        {
            pictureBox1.Image = new Bitmap(187,187);
            Graphics grafik1 = Graphics.FromImage(pictureBox1.Image);
            grafik1.SmoothingMode = System.Drawing.Drawing2D.SmoothingMode.AntiAlias;
            grafik1.DrawImage(Resources.kollision, 78, 78);

            grafik1.DrawEllipse(pen2, 93 - (int)(Math.Cos((double)T1.winkel * Math.PI / 180.0) * 82) - 5, 93 - (int)(Math.Sin((double)T1.winkel * Math.PI / 180.0) * 82) - 5, 10, 10);
            grafik1.DrawLine(pen1, 93 - (int)(Math.Cos((double)T1.winkel * Math.PI / 180.0) * 15), 93 - (int)(Math.Sin((double)T1.winkel * Math.PI / 180.0) * 15), 93 - (int)(Math.Cos((double)T1.winkel * Math.PI / 180.0) * 73), 93 - (int)(Math.Sin((double)T1.winkel * Math.PI / 180.0) * 73));
            grafik1.DrawLine(pen1, 93 - (int)(Math.Cos((double)T1.winkel * Math.PI / 180.0) * 15), 93 - (int)(Math.Sin((double)T1.winkel * Math.PI / 180.0) * 15), 93 - (int)(Math.Cos((double)(T1.winkel + 15) * Math.PI / 180.0) * 25), 93 - (int)(Math.Sin((double)(T1.winkel + 15) * Math.PI / 180.0) * 25));
            grafik1.DrawLine(pen1, 93 - (int)(Math.Cos((double)T1.winkel * Math.PI / 180.0) * 15), 93 - (int)(Math.Sin((double)T1.winkel * Math.PI / 180.0) * 15), 93 - (int)(Math.Cos((double)(T1.winkel - 15) * Math.PI / 180.0) * 25), 93 - (int)(Math.Sin((double)(T1.winkel - 15) * Math.PI / 180.0) * 25));
            label35.Location = new Point(pictureBox1.Location.X + 93 - (int)(Math.Cos((double)T1.winkel * Math.PI / 180.0) * 82) - 6, pictureBox1.Location.Y + 93 - (int)(Math.Sin((double)T1.winkel * Math.PI / 180.0) * 82) - 6);

            grafik1.DrawEllipse(pen3, 93 - (int)(Math.Cos((double)T2.winkel * Math.PI / 180.0) * 82) - 5, 93 - (int)(Math.Sin((double)T2.winkel * Math.PI / 180.0) * 82) - 5, 10, 10);
            grafik1.DrawLine(pen1, 93 - (int)(Math.Cos((double)T2.winkel * Math.PI / 180.0) * 15), 93 - (int)(Math.Sin((double)T2.winkel * Math.PI / 180.0) * 15), 93 - (int)(Math.Cos((double)T2.winkel * Math.PI / 180.0) * 73), 93 - (int)(Math.Sin((double)T2.winkel * Math.PI / 180.0) * 73));
            grafik1.DrawLine(pen1, 93 - (int)(Math.Cos((double)T2.winkel * Math.PI / 180.0) * 15), 93 - (int)(Math.Sin((double)T2.winkel * Math.PI / 180.0) * 15), 93 - (int)(Math.Cos((double)(T2.winkel + 15) * Math.PI / 180.0) * 25), 93 - (int)(Math.Sin((double)(T2.winkel + 15) * Math.PI / 180.0) * 25));
            grafik1.DrawLine(pen1, 93 - (int)(Math.Cos((double)T2.winkel * Math.PI / 180.0) * 15), 93 - (int)(Math.Sin((double)T2.winkel * Math.PI / 180.0) * 15), 93 - (int)(Math.Cos((double)(T2.winkel - 15) * Math.PI / 180.0) * 25), 93 - (int)(Math.Sin((double)(T2.winkel - 15) * Math.PI / 180.0) * 25));
            label36.Location = new Point(pictureBox1.Location.X + 93 - (int)(Math.Cos((double)T2.winkel * Math.PI / 180.0) * 82) - 6, pictureBox1.Location.Y + 93 - (int)(Math.Sin((double)T2.winkel * Math.PI / 180.0) * 82) - 6);
        }

        /*
        private void drawexplosion()
        {
            pictureBox2.Image = new Bitmap(187, 187);
            Graphics grafik1 = Graphics.FromImage(pictureBox2.Image);
            grafik1.SmoothingMode = System.Drawing.Drawing2D.SmoothingMode.AntiAlias;
            grafik1.DrawImage(Resources.kollision, 78, 78);

            grafik1.DrawEllipse(pen4, 93 + (int)(Math.Cos((double)T3.winkel * Math.PI / 180.0) * 83) - 5, 93 + (int)(Math.Sin((double)T3.winkel * Math.PI / 180.0) * 83) - 5, 10, 10);
            grafik1.DrawLine(pen1, 93 + (int)(Math.Cos((double)T3.winkel * Math.PI / 180.0) * 15), 93 + (int)(Math.Sin((double)T3.winkel * Math.PI / 180.0) * 15), 93 + (int)(Math.Cos((double)T3.winkel * Math.PI / 180.0) * 73), 93 + (int)(Math.Sin((double)T3.winkel * Math.PI / 180.0) * 73));
            grafik1.DrawLine(pen1, 93 + (int)(Math.Cos((double)T3.winkel * Math.PI / 180.0) * 73), 93 + (int)(Math.Sin((double)T3.winkel * Math.PI / 180.0) * 73), 93 + (int)(Math.Cos((double)(T3.winkel + 5) * Math.PI / 180.0) * 63), 93 + (int)(Math.Sin((double)(T3.winkel + 5) * Math.PI / 180.0) * 63));
            grafik1.DrawLine(pen1, 93 + (int)(Math.Cos((double)T3.winkel * Math.PI / 180.0) * 73), 93 + (int)(Math.Sin((double)T3.winkel * Math.PI / 180.0) * 73), 93 + (int)(Math.Cos((double)(T3.winkel - 5) * Math.PI / 180.0) * 63), 93 + (int)(Math.Sin((double)(T3.winkel - 5) * Math.PI / 180.0) * 63));
            label37.Location = new Point(pictureBox2.Location.X + 93 + (int)(Math.Cos((double)T3.winkel * Math.PI / 180.0) * 82) - 6, pictureBox2.Location.Y + 93 + (int)(Math.Sin((double)T3.winkel * Math.PI / 180.0) * 82) - 6);
        }
        */
        private void drawexplosion()
        {
            label38.Visible = true;
            label37.Visible = true;
            pictureBox2.Visible = true;
            pictureBox2.Image = new Bitmap(187, 187);
            Graphics grafik1 = Graphics.FromImage(pictureBox2.Image);
            grafik1.SmoothingMode = System.Drawing.Drawing2D.SmoothingMode.AntiAlias;
            grafik1.DrawImage(Resources.kollision, 78, 78);

            grafik1.DrawEllipse(pen4, 93 + (int)(Math.Cos((double)T3.winkel * Math.PI / 180.0) * 83) - 5, 93 + (int)(Math.Sin((double)T3.winkel * Math.PI / 180.0) * 83) - 5, 10, 10);
            grafik1.DrawLine(pen1, 93 + (int)(Math.Cos((double)T3.winkel * Math.PI / 180.0) * 15), 93 + (int)(Math.Sin((double)T3.winkel * Math.PI / 180.0) * 15), 93 + (int)(Math.Cos((double)T3.winkel * Math.PI / 180.0) * 73), 93 + (int)(Math.Sin((double)T3.winkel * Math.PI / 180.0) * 73));
            grafik1.DrawLine(pen1, 93 + (int)(Math.Cos((double)T3.winkel * Math.PI / 180.0) * 73), 93 + (int)(Math.Sin((double)T3.winkel * Math.PI / 180.0) * 73), 93 + (int)(Math.Cos((double)(T3.winkel + 5) * Math.PI / 180.0) * 63), 93 + (int)(Math.Sin((double)(T3.winkel + 5) * Math.PI / 180.0) * 63));
            grafik1.DrawLine(pen1, 93 + (int)(Math.Cos((double)T3.winkel * Math.PI / 180.0) * 73), 93 + (int)(Math.Sin((double)T3.winkel * Math.PI / 180.0) * 73), 93 + (int)(Math.Cos((double)(T3.winkel - 5) * Math.PI / 180.0) * 63), 93 + (int)(Math.Sin((double)(T3.winkel - 5) * Math.PI / 180.0) * 63));
            label37.Location = new Point(pictureBox2.Location.X + 93 + (int)(Math.Cos((double)T3.winkel * Math.PI / 180.0) * 82) - 6, pictureBox2.Location.Y + 93 + (int)(Math.Sin((double)T3.winkel * Math.PI / 180.0) * 82) - 6);

            grafik1.DrawEllipse(pen5, 93 + (int)(Math.Cos((double)T4.winkel * Math.PI / 180.0) * 83) - 5, 93 + (int)(Math.Sin((double)T4.winkel * Math.PI / 180.0) * 83) - 5, 10, 10);
            grafik1.DrawLine(pen1, 93 + (int)(Math.Cos((double)T4.winkel * Math.PI / 180.0) * 15), 93 + (int)(Math.Sin((double)T4.winkel * Math.PI / 180.0) * 15), 93 + (int)(Math.Cos((double)T4.winkel * Math.PI / 180.0) * 75), 93 + (int)(Math.Sin((double)T4.winkel * Math.PI / 180.0) * 75));
            grafik1.DrawLine(pen1, 93 + (int)(Math.Cos((double)T4.winkel * Math.PI / 180.0) * 73), 93 + (int)(Math.Sin((double)T4.winkel * Math.PI / 180.0) * 73), 93 + (int)(Math.Cos((double)(T4.winkel + 5) * Math.PI / 180.0) * 63), 93 + (int)(Math.Sin((double)(T4.winkel + 5) * Math.PI / 180.0) * 63));
            grafik1.DrawLine(pen1, 93 + (int)(Math.Cos((double)T4.winkel * Math.PI / 180.0) * 73), 93 + (int)(Math.Sin((double)T4.winkel * Math.PI / 180.0) * 73), 93 + (int)(Math.Cos((double)(T4.winkel - 5) * Math.PI / 180.0) * 63), 93 + (int)(Math.Sin((double)(T4.winkel - 5) * Math.PI / 180.0) * 63));
            label38.Location = new Point(pictureBox2.Location.X + 93 + (int)(Math.Cos((double)T4.winkel * Math.PI / 180.0) * 82) - 6, pictureBox2.Location.Y + 93 + (int)(Math.Sin((double)T4.winkel * Math.PI / 180.0) * 82) - 6);
        }

        private double getmasse(string p)
        {
            double ruheenergie;
            if (p == "Proton")
                ruheenergie = 0.938272;
            else if (p == "Neutron")
                ruheenergie = 0.938565;
            else if (p == "Elektron")
                ruheenergie = 0.000511;
            else
                ruheenergie = 0.000001;
            return ruheenergie;
        }




    }
    class Teilchen
    {
        public double ruheenergie;
        public double kinenergie;
        public double energie;
        public double impuls;
        public double v;
        public double px;
        public double py;
        public decimal winkel = 0;
    }
}
