﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Drawing;
using System.Collections;

namespace WindowsFormsApplication1
{
    /// <summary>
    /// Class that stores information about a Lemming.
    /// </summary>
    class Lemming
    {
        int status=1;
        Color color;
        int x;
        int y;
        int id;
        int fallheight;

        /// <summary>
        /// Lemming-Constructor.
        /// </summary>
        /// <param name="x">x-coordinate of the Lemming.</param>
        /// <param name="y">y-coordinate of the Lemming.</param>
        /// <param name="id">Initial x-direction in which the Lemming moves on ground.</param>
        /// <param name="color">Color of the Lemming.</param>
        public Lemming(int x, int y, int id, Color color)
        {
            this.x = x;
            this.y = y;
            this.id=id;
            this.color = color;
            fallheight = 0;
        }

        /// <summary>
        /// Gets or sets the color of the Lemming.
        /// </summary>
        public Color Lemmingcolor
        {
            get { return color; }
            set { color = value; }
        }

        /// <summary>
        /// Gets or sets the x-coordinate of the Lemming.
        /// </summary>
        public int X
        {
            get { return x; }
            set { x = value; }
        }

        /// <summary>
        /// Gets or sets the y-coordinate of the Lemming.
        /// </summary>
        public int Y
        {
            get { return y; }
            set { y = value; }
        }

        /// <summary>
        /// Gets or sets the direction in which the Lemming moves on ground.
        /// </summary>
        public int ID
        {
            get { return id; }
            set { id = value; }
        }

        /// <summary>
        /// Draws the Lemming on the board.
        /// </summary>
        /// <param name="g"></param>
        public void Draw(Graphics g)
        {
            g.DrawEllipse(new Pen(color), x, y, 10, 10);
            g.FillEllipse(new SolidBrush(color), x, y, 10, 10);
        }

        /// <summary>
        /// Gets or sets the status of the Lemming.
        /// </summary>
        public int Status
        {
            get { return status; }
            set { status = value; }
        }

        /// <summary>
        /// Gets or sets the height a Lemming has been fallen down at once.
        /// </summary>
        public int Fallheight
        {
            get { return fallheight; }
            set { fallheight = value; }
        }
    }

    /// <summary>
    /// Collection of Lemmings
    /// </summary>
    class LemmingCollection : CollectionBase
    {

        /// <summary>
        /// Adds a Lemming to the collection
        /// </summary>
        /// <param name="lemming"></param>
        public void Add (Lemming lemming)
        {
            this.List.Add(lemming);
        }

        /// <summary>
        /// Removes a Lemming from the collection
        /// </summary>
        /// <param name="lemming"></param>
        public void Remove(Lemming lemming)
        {
            this.List.Remove(lemming);
        }

        /// <summary>
        /// Gets or sets a Lemming at a certain position
        /// </summary>
        /// <param name="index">Position of the Lemming</param>
        /// <returns></returns>
        public Lemming this[int index]
        {
            get
            {
                return (Lemming)List[index];
            }
            set
            {
                List[index] = value;
            }
        }
    }
}
