﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;
using System.IO;
using System.Xml.Serialization;

namespace WindowsFormsApplication1
{
    /// <summary>
    /// Start-screen
    /// </summary>
    public partial class Form1 : Form
    {
        bool saveAllowed = true;
        public Form1()
        {
            InitializeComponent();
        }

        private void quitButton_Click(object sender, EventArgs e)
        {
            Application.Exit();
        }

        private void button1_Click(object sender, EventArgs e)
        {
            GameOptions go = new GameOptions();
            this.Hide();
            go.ShowDialog();
            if (go.DialogResult == DialogResult.OK)
            {
                saveAllowed = go.SaveAllowed;
                this.startGame(go.Lemmingscolor, go.PlayerName);
            }
            else
            {
                this.Show();
            }
        }

        /// <summary>
        /// Starts the game.
        /// </summary>
        /// <param name="lemmingscolor">Color of the Lemmings</param>
        /// <param name="playerName">Name of the player.</param>
        public void startGame(Color lemmingscolor, string playerName)
        {
            openGame(lemmingscolor, playerName, 1);
        }

        /// <summary>
        /// Opens the window showing the game.
        /// </summary>
        /// <param name="lemmingscolor">Color of the Lemmings.</param>
        /// <param name="playerName">Name of the player.</param>
        /// <param name="level">Number of the Level to start with.</param>
        public void openGame(Color lemmingscolor, string playerName, int level)
        {
            GameFrame gf = new GameFrame(lemmingscolor, playerName, saveAllowed, level);
            gf.ShowDialog();
        }

    }
}
