﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;

namespace WindowsFormsApplication1
{
    /// <summary>
    /// Form to choose some Options and insert the name of the player.
    /// </summary>
    public partial class GameOptions : Form
    {
        Color lemmingscolor = Color.SandyBrown;
        public GameOptions()
        {
            InitializeComponent();
            checkBox1.Checked = true;
            textBox1.Text = "Name";
        }

        /// <summary>
        /// Gets the color of the Lemmings.
        /// </summary>
        public Color Lemmingscolor
        {
            get { return lemmingscolor; }
        }

        /// <summary>
        /// Gets the name of the player.
        /// </summary>
        public string PlayerName
        {
            get { return textBox1.Text; }
        }

        /// <summary>
        /// Gets or sets whether the player is allowed to save the game by hisself/herself.
        /// </summary>
        public bool SaveAllowed
        {
            get { return checkBox1.Checked; }
            set { checkBox1.Checked = value; }
        }

        private void checkBox1_MouseHover(object sender, EventArgs e)
        {
            toolTip1.Show("Falls diese Option gesetzt ist können sie jederzeit ihr Spiel speichern; Bei Programm-Ende wird automatisch eine Sicherungsdatei 'auto' erstellt. \r\n Ist diese Option nicht gesetzt öffnet sich beim Schließen automatisch ein Speicher-Dialog.", this);
        }

        private void colorButton_Click(object sender, EventArgs e)
        {
            if (colorDialog1.ShowDialog() == DialogResult.OK)
            {
                lemmingscolor = colorDialog1.Color;
                colorButton.BackColor = lemmingscolor;
            }
        }

        private void startButton_Click(object sender, EventArgs e)
        {
            if (textBox1.Text!="" && textBox1.Text != null)     //Name has to be set.
                this.DialogResult = DialogResult.OK;
            else
                MessageBox.Show("Bitte Spieler-Namen eingeben!");
        }

        private void cancelButton_Click(object sender, EventArgs e)
        {
            this.Close();
        }
    }
}
