﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.IO;
using System.Xml.Serialization;
using System.Windows.Forms;

namespace Makro
{
    [Serializable]
    public class dateien
    {
        #region Variablen
        /// <summary>
        /// enthält die Liste in [i][0] und die zugehörigen Makroinformationen in [i][1.....]
        /// </summary>
        public List<string[]> Liste = new List<string[]>();
        #endregion 
       
        #region GET SET
        
        public string[][] sList
        {
            get
            {
                return Liste.ToArray();
            }
            set
            {
                Liste = value.ToList();
            }
        }
        #endregion

        #region Methoden

        public dateien()
        {
        }
        public static dateien LoadValues(string s_datei)
        {
            dateien zwischenklasse = new dateien();
            if (File.Exists(s_datei))
            {
                FileInfo finfo = new FileInfo(s_datei);
                XmlSerializer xml = new XmlSerializer(typeof(dateien));
                FileStream fs = File.Open(s_datei, FileMode.Open, FileAccess.Read);
                try
                {
                    zwischenklasse = (dateien)xml.Deserialize(fs);
                }
                catch { }
                finally
                {
                    fs.Close();
                }
            }
            return zwischenklasse;
        }

        public void SaveValues(string s_datei)
        {
            XmlSerializer xml = new XmlSerializer(typeof(dateien));
            FileStream fs = File.Open(s_datei, FileMode.Create, FileAccess.Write);
            try
            {
                xml.Serialize(fs, this);
            }
            catch (Exception ex)
            {
                MessageBox.Show(ex.Message);
            }
            finally
            {
                fs.Close();
            }
        }
        #endregion
    }
}
