﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Windows.Forms;

namespace GameObjects
{
    public class ClsGameObjects : MarshalByRefObject
    {
        public static ClsGameObjects theObject;

        private bool connected;
        public bool Connected
        {
            get { return connected; }
            set { connected = value; }
        }

        private bool serverClosed;
        public bool ServerClosed
        {
            get { return serverClosed; }
            set { serverClosed = value; }
        }

        private Player1 player1;
        public Player1 Player1
        {
            get { return player1; }
            set { player1 = value; }
        }
        private Player2 player2;
        public Player2 Player2
        {
            get { return player2; }
            set { player2 = value; }
        }

        private int winSize_x;
        public int WinSize_x
        {
            get { return winSize_x; }
            set { winSize_x = value; }
        }
        private int winSize_y;
        public int WinSize_y
        {
            get { return winSize_y; }
            set { winSize_y = value; }
        }

        private List<Astroid> astroidList;

        public List<Astroid> AstroidList
        {
            get { return astroidList; }
            set { astroidList = value; }
        }

        public ClsGameObjects(int winSize_x, int winSize_y)
        {
            WinSize_x = winSize_x;
            WinSize_y = winSize_y;
            player1 = new Player1("Player1", 20, 150, winSize_x, winSize_y);
            player2 = new Player2("Player2", 20, 150, winSize_x, winSize_y);
            astroidList = new List<Astroid>();
            theObject = this;
            Connected = false;
            ServerClosed = false;
        }      
    }


    public abstract class Player : MarshalByRefObject
    {
        private string name;
        public string Name
        {
            get { return name; }
            set { name = value; }
        }
        private bool host;
        public bool Host
        {
            get { return host; }
            set { host = value; }
        }
        private int health;
        public int Health
        {
            get { return health; }
            set { health = value; }
        }
        private int ammo;
        public int Ammo
        {
            get { return ammo; }
            set { ammo = value; }
        }
        private bool fired;
        public bool Fired
        {
            get { return fired; }
            set { fired = value; }
        }

        private int winSize_x;
        public int WinSize_x
        {
            get { return winSize_x; }
            set { winSize_x = value; }
        }
        private int winSize_y;
        public int WinSize_y
        {
            get { return winSize_y; }
            set { winSize_y = value; }
        }

        private Jet jet;
        public Jet Jet
        {
            get { return jet; }
            set { jet = value; }
        }

        protected List<Bullet> bulletlist;

        public List<Bullet> Bulletlist
        {
            get { return bulletlist; }
            set { bulletlist = value; }
        }   

        public Player(string name, int health, int ammo, int winSize_x, int winSize_y)
        {
            Name = name;
            Health = health;
            Ammo = ammo;
            WinSize_x = winSize_x;
            WinSize_y = winSize_y;
            bulletlist = new List<Bullet>();
            Fired = false;
        }
    }

    public class Player1 : Player
    {
        public Player1(string name, int health, int ammo, int winSize_x, int winSize_y)
            : base(name, health, ammo, winSize_x, winSize_y)
        {
            Jet = new Jet1(0, winSize_y/2);
 
        }
    }

    public class Player2 : Player
    {
        public Player2(string name, int health, int ammo, int winSize_x, int winSize_y)
            : base(name, health, ammo, winSize_x, winSize_y)
        {
            Jet = new Jet2(winSize_x, winSize_y/2);

        }
    }

    public abstract class Jet : MarshalByRefObject
    {
        private int height;
        public int Height
        {
            get { return height; }
            set { height = value; }
        }
        private int width;
        public int Width
        {
            get { return width; }
            set { width = value; }
        }
        private int cockpit_size;
        public int Cockpit_size
        {
            get { return cockpit_size; }
            set { cockpit_size = value; }
        }
        private int speed;
        public int Speed
        {
            get { return speed; }
            set { speed = value; }
        }
        private int pos_x;
        public int Pos_x
        {
            get { return pos_x; }
            set { pos_x = value; }
        }
        private int pos_y;
        public int Pos_y
        {
            get { return pos_y; }
            set { pos_y = value; }
        }

        public Jet(int start_x, int start_y)
        {
            pos_x = start_x;
            pos_y = start_y;
            width = 30;
            height = 25;
            cockpit_size = 12;
            speed = 10;
        }

        public abstract void Move(Keys dir, int pbHeight, int pbWidth);

        public abstract void Shoot(List<Bullet> bulletList, Player player);

        public abstract void Draw(Graphics g);

    }

    public class Jet1 : Jet
    {
        public Jet1(int start_x, int start_y) : base(start_x, start_y) { }

        public override void Move(Keys dir, int pbHeight, int pbWidth)
        {
            switch (dir)
            {
                case Keys.D:
                    if (Pos_x + Width + Cockpit_size < pbWidth / 2)
                        Pos_x += Speed;
                    break;
                case Keys.S:
                    if (Pos_y + Height < pbHeight)
                        Pos_y += Speed;
                    break;
                case Keys.A:
                    if (Pos_x > 0)
                        Pos_x -= Speed;
                    break;
                case Keys.W:
                    if (Pos_y > 0)
                        Pos_y -= Speed;
                    break;

               // not nice, but works
                case Keys.Right:
                    if (Pos_x + Width + Cockpit_size < pbWidth / 2)
                        Pos_x += Speed;
                    break;
                case Keys.Down:
                    if (Pos_y + Height < pbHeight)
                        Pos_y += Speed;
                    break;
                case Keys.Left:
                    if (Pos_x > 0)
                        Pos_x -= Speed;
                    break;
                case Keys.Up:
                    if (Pos_y > 0)
                        Pos_y -= Speed;
                    break;
            }

        }

        public override void Shoot(List<Bullet> bulletList, Player player)
        {
            if (player.Ammo != 0)
            {
                Bullet1 bullet = new Bullet1(Pos_x + Width + Cockpit_size, Pos_y + Height / 2);
                bulletList.Add(bullet);
                player.Ammo--;
            }
        }

        public override void Draw(Graphics g)
        {
            g.FillRectangle(Brushes.Blue, Pos_x, Pos_y, Width, Height);
            g.FillRectangle(Brushes.Gray, Pos_x + Width, Pos_y + Height / 2 - Cockpit_size / 2, Cockpit_size, Cockpit_size);
        }
    }

    public class Jet2 : Jet
    {
        public Jet2(int start_x, int start_y) : base(start_x, start_y) { }

        public override void Move(Keys dir, int pbHeight, int pbWidth)
        {
            switch (dir)
            {
                case Keys.Right:
                    if (Pos_x < pbWidth)
                        Pos_x += Speed;
                    break;
                case Keys.Down:
                    if (Pos_y + Height < pbHeight)
                        Pos_y += Speed;
                    break;
                case Keys.Left:
                    if (Pos_x > pbWidth/2 + Width + 2*Cockpit_size)
                        Pos_x -= Speed;
                    break;
                case Keys.Up:
                    if (Pos_y > 0)
                        Pos_y -= Speed;
                    break;
            }

        }

        public override void Shoot(List<Bullet> bulletList, Player player)
        {
            if (player.Ammo != 0)
            {
                Bullet2 bullet = new Bullet2(Pos_x-Width-Cockpit_size, Pos_y + Height / 2);
                bulletList.Add(bullet);
                player.Ammo--;
            }
        }

        public override void Draw(Graphics g)
        {
            g.FillRectangle(Brushes.Blue, Pos_x - Width, Pos_y, Width, Height);
            g.FillRectangle(Brushes.Gray, Pos_x - Width - Cockpit_size, Pos_y + Height / 2 - Cockpit_size / 2, Cockpit_size, Cockpit_size);
        }

   }

    public class Bullet : MarshalByRefObject
    {
        public int pos_x;
        public int pos_y;
        public int speed;
        public int length;
        public bool hasHit;

        public Bullet(int start_x, int start_y)
        {
            pos_x = start_x;
            pos_y = start_y;
            speed = 10;
            length = 5;
            hasHit = false;

        }


/*        public void Draw(Graphics g)
        {
            if (!hasHit)
            {
                g.DrawLine(drawer, pos_x, pos_y, pos_x + length, pos_y);
            }
        } */

        public virtual void Update(Graphics g, ClsGameObjects gameObjects){}
    }

    public class Bullet1 : Bullet
    {
        public Bullet1 (int start_x, int start_y) : base(start_x, start_y){}

        public override void Update(Graphics g, ClsGameObjects gameObjects)
        {
            if (!hasHit)
            {
                if (pos_x > gameObjects.Player2.Jet.Pos_x - gameObjects.Player2.Jet.Width && pos_y > gameObjects.Player2.Jet.Pos_y && pos_y < gameObjects.Player2.Jet.Pos_y + gameObjects.Player2.Jet.Height)
                {
                    hasHit = true;
                    if (gameObjects.Player2.Health > 0)
                        gameObjects.Player2.Health--;
                    else
                        GameOver.Show(gameObjects.Player1);

                 }
            }
             pos_x += speed;

        }
    }

    public class Bullet2 : Bullet
    {
        public Bullet2(int start_x, int start_y) : base(start_x, start_y) { }

        public override void Update(Graphics g, ClsGameObjects gameObjects)
        {
            if (!hasHit)
            {
                if (pos_x < gameObjects.Player1.Jet.Pos_x + gameObjects.Player1.Jet.Width && pos_y > gameObjects.Player1.Jet.Pos_y && pos_y < gameObjects.Player1.Jet.Pos_y + gameObjects.Player2.Jet.Height)
                {
                    hasHit = true;
                    if (gameObjects.Player1.Health > 0)
                        gameObjects.Player1.Health--;
                    else
                            GameOver.Show(gameObjects.Player2);
                }
            }     
            pos_x -= speed;
 
        }
    }

    public class Astroid : MarshalByRefObject
    {
        private int size;

        public int Size
        {
            get { return size; }
            set { size = value; }
        }
        private int speed;

        public int Speed
        {
            get { return speed; }
            set { speed = value; }
        }

        private int angle;

        public int Angle
        {
            get { return angle; }
            set { angle = value; }
        }

        private int pos_x;

        public int Pos_x
        {
            get { return pos_x; }
            set { pos_x = value; }
        }
        private int pos_y;

        public int Pos_y
        {
            get { return pos_y; }
            set { pos_y = value; }
        }

        public bool hasHit;

        public Astroid(int winSize_x, int winSize_y)
        {
            Random random = new Random();
            Size = random.Next(20)+5;
            speed = random.Next(5)+1;
            pos_x = random.Next(winSize_x);
            pos_y = random.Next(winSize_y);
            angle = random.Next(360);
            hasHit = false;
        }

        public void Draw(Graphics g)
        {
            if (!hasHit)
                g.FillEllipse(Brushes.Brown, Pos_x, Pos_y, Size, Size);
        }

        public void Update(Graphics g, ClsGameObjects gameObjects)
        {
            if (!hasHit)
            {
                if (pos_x + size > gameObjects.Player1.Jet.Pos_x
                    && pos_x - size < gameObjects.Player1.Jet.Pos_x + gameObjects.Player1.Jet.Width
                    && pos_y - size < gameObjects.Player1.Jet.Pos_y + gameObjects.Player1.Jet.Height
                    && pos_y + size > gameObjects.Player1.Jet.Pos_y )
                {
                    hasHit = true;
                    if (gameObjects.Player1.Health > 0)
                        gameObjects.Player1.Health--;
                    else
                        GameOver.Show(gameObjects.Player2);
                }
                if (pos_x + size > gameObjects.Player2.Jet.Pos_x - gameObjects.Player2.Jet.Width - gameObjects.Player2.Jet.Cockpit_size
                    && pos_x - size < gameObjects.Player2.Jet.Pos_x + gameObjects.Player2.Jet.Width
                    && pos_y - size < gameObjects.Player2.Jet.Pos_y + gameObjects.Player2.Jet.Height
                    && pos_y + size > gameObjects.Player2.Jet.Pos_y)
                {
                    hasHit = true;
                    if (gameObjects.Player2.Health > 0)
                        gameObjects.Player2.Health--;
                    else
                        GameOver.Show(gameObjects.Player1);
                }
            }       
            
            Pos_x += (int)(Math.Cos(2*Math.PI/360*(double)angle) * speed);
            Pos_y += (int)(Math.Sin(2 * Math.PI / 360 * (double)angle) * speed);
        }
        
        static public int Timeout = 100;
    }

    static public class GameOver
    {
        static bool end = false;

        public static bool End
        {
            get { return GameOver.end; }
            set { GameOver.end = value; }
        }
        static public void Show(Player player)
        {
            if (end == false)
            {
                end = true;
                MessageBox.Show(@"Game Over! Spieler " + player.Name + " hat gewonnen!");
            }
        }
    }
}
