﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;
using GameObjects;
using System.Threading;
using System.Runtime.Remoting;
using System.Runtime.Remoting.Channels;
using System.Runtime.Remoting.Channels.Tcp;
using Services;
using Service.Internal;

namespace WindowsFormsApplication2
{
    public partial class Form1 : Form
    {
        private Bitmap bmp;
        private Pen p1, p2;
        private Graphics g;
        private ClsGameObjects gameObjects;
        private Thread thread;
        private bool stillOpen;
        private int timeElapsed;
        private bool localGame;
        private bool localPlayerIsHost;
  
        // network
        private TcpChannel serverChan, clientChan;

        delegate void RefreshBitmapDelegate();
        delegate void RefreshProgessBarDelegate();
        
        public Form1()
        {
            InitializeComponent();
            SetStyle(ControlStyles.OptimizedDoubleBuffer | ControlStyles.FixedHeight | ControlStyles.FixedWidth | ControlStyles.AllPaintingInWmPaint | ControlStyles.UserPaint, true);
       }

        private void startGame()
        {
            stillOpen = true;
                bmp = new Bitmap(pictureBox1.Width, pictureBox1.Height);
                g = Graphics.FromImage(bmp);
                progressBar1.Visible = true;
                progressBar2.Visible = true;
                progressBar3.Visible = true;
                progressBar4.Visible = true;
                pictureBox1.Image = bmp;
            thread = new Thread(DrawGraphics);
            thread.Start();
            GameOver.End = false;
            {
                timer1.Interval = 1;
                timer1.Start();
                timeElapsed = 0;
            }
        }

        private void DrawGraphics()
        {
            while (stillOpen)
            {
                    p1 = new Pen(Color.White, 5);
                    p2 = new Pen(Color.Yellow, 2);
                    g.FillRectangle(Brushes.Black, new Rectangle(0, 0, pictureBox1.Width, pictureBox1.Height));
                    g.DrawLine(p1, this.Width / 2, 0, this.Width / 2, this.Height);

                    g.FillRectangle(Brushes.Blue, gameObjects.Player1.Jet.Pos_x, gameObjects.Player1.Jet.Pos_y, gameObjects.Player1.Jet.Width, gameObjects.Player1.Jet.Height);
                    g.FillRectangle(Brushes.Gray, gameObjects.Player1.Jet.Pos_x + gameObjects.Player1.Jet.Width, gameObjects.Player1.Jet.Pos_y + gameObjects.Player1.Jet.Height / 2 - gameObjects.Player1.Jet.Cockpit_size / 2, gameObjects.Player1.Jet.Cockpit_size, gameObjects.Player1.Jet.Cockpit_size);
                    g.FillRectangle(Brushes.Blue, gameObjects.Player2.Jet.Pos_x - gameObjects.Player2.Jet.Width, gameObjects.Player2.Jet.Pos_y, gameObjects.Player2.Jet.Width, gameObjects.Player2.Jet.Height);
                    g.FillRectangle(Brushes.Gray, gameObjects.Player2.Jet.Pos_x - gameObjects.Player2.Jet.Width - gameObjects.Player2.Jet.Cockpit_size, gameObjects.Player2.Jet.Pos_y + gameObjects.Player2.Jet.Height / 2 - gameObjects.Player2.Jet.Cockpit_size / 2, gameObjects.Player2.Jet.Cockpit_size, gameObjects.Player2.Jet.Cockpit_size);
                    lock (this)
                        {
                            for (int i = 0; i < gameObjects.Player1.Bulletlist.Count; i++)
                            {
                                Bullet b = gameObjects.Player1.Bulletlist[i];
                                if (!b.hasHit)
                                {
                                    g.DrawLine(p2, b.pos_x, b.pos_y, b.pos_x + b.length, b.pos_y);
                                }
                            }
                            for (int i = 0; i < gameObjects.Player2.Bulletlist.Count; i++)
                            {
                                Bullet b = gameObjects.Player2.Bulletlist[i];
                                if (!b.hasHit)
                                {
                                    g.DrawLine(p2, b.pos_x, b.pos_y, b.pos_x + b.length, b.pos_y);
                                }
                            }
                            for (int i = 0; i < gameObjects.AstroidList.Count; i++)
                            {
                                Astroid ast = gameObjects.AstroidList[i];
                                if (!ast.hasHit)
                                    g.FillEllipse(Brushes.Brown, ast.Pos_x, ast.Pos_y, ast.Size, ast.Size);
                            }
                    pictureBox1.Image = bmp;
                    if (pictureBox1 != null)
                        pictureBox1.Invoke(new RefreshBitmapDelegate(pictureBox1.Refresh));
                   }
             }
        }

        private void Form1_KeyDown(object sender, KeyEventArgs e)
        {
            if (GameOver.End == false)
            {
 //               lock (this)
                {
                    if (localGame) // local game
                    {
                        switch (e.KeyData)
                        {
                            // Player 1
                            case Keys.D:
                                if (gameObjects.Player1.Jet.Pos_x + gameObjects.Player1.Jet.Width + gameObjects.Player1.Jet.Cockpit_size < pictureBox1.Width / 2)
                                    gameObjects.Player1.Jet.Pos_x += gameObjects.Player1.Jet.Speed;
                                break;
                            case Keys.S:
                                if (gameObjects.Player1.Jet.Pos_y + gameObjects.Player1.Jet.Height < pictureBox1.Height)
                                    gameObjects.Player1.Jet.Pos_y += gameObjects.Player1.Jet.Speed;
                                break;
                            case Keys.A:
                                if (gameObjects.Player1.Jet.Pos_x > 0)
                                    gameObjects.Player1.Jet.Pos_x -= gameObjects.Player1.Jet.Speed;
                                break;
                            case Keys.W:
                                if (gameObjects.Player1.Jet.Pos_y > 0)
                                    gameObjects.Player1.Jet.Pos_y -= gameObjects.Player1.Jet.Speed;
                                break;
                            case Keys.Space:
                                if (gameObjects.Player1.Ammo != 0)
                                {
                                    Bullet1 bullet = new Bullet1(gameObjects.Player1.Jet.Pos_x + gameObjects.Player1.Jet.Width + gameObjects.Player1.Jet.Cockpit_size, gameObjects.Player1.Jet.Pos_y + gameObjects.Player1.Jet.Height / 2);
                                    gameObjects.Player1.Bulletlist.Add(bullet);
                                    gameObjects.Player1.Ammo--;
                                }
                                break;

                            // Player 2
                            case Keys.Right:
                                if (gameObjects.Player2.Jet.Pos_x < pictureBox1.Width)
                                    gameObjects.Player2.Jet.Pos_x += gameObjects.Player2.Jet.Speed;
                                break;
                            case Keys.Down:
                                if (gameObjects.Player2.Jet.Pos_y + gameObjects.Player2.Jet.Height < pictureBox1.Height)
                                    gameObjects.Player2.Jet.Pos_y += gameObjects.Player2.Jet.Speed;
                                break;
                            case Keys.Left:
                                if (gameObjects.Player2.Jet.Pos_x > pictureBox1.Width / 2 + gameObjects.Player2.Jet.Width + 2 * gameObjects.Player2.Jet.Cockpit_size)
                                    gameObjects.Player2.Jet.Pos_x -= gameObjects.Player2.Jet.Speed;
                                break;
                            case Keys.Up:
                                if (gameObjects.Player2.Jet.Pos_y > 0)
                                    gameObjects.Player2.Jet.Pos_y -= gameObjects.Player2.Jet.Speed;
                                break;
                            case Keys.Return:
                                if (gameObjects.Player2.Ammo != 0)
                                {
                                    Bullet2 bullet = new Bullet2(gameObjects.Player2.Jet.Pos_x - gameObjects.Player2.Jet.Width - gameObjects.Player2.Jet.Cockpit_size, gameObjects.Player2.Jet.Pos_y + gameObjects.Player2.Jet.Height / 2);
                                    gameObjects.Player2.Bulletlist.Add(bullet);
                                    gameObjects.Player2.Ammo--;
                                }
                                break;

                        }
                     }
                    else  // network game
                    {
                        if (localPlayerIsHost)
                        {
                            switch (e.KeyData)
                            {
                                case Keys.Right:
                                    if (gameObjects.Player1.Jet.Pos_x < pictureBox1.Width)
                                        gameObjects.Player1.Jet.Pos_x += gameObjects.Player1.Jet.Speed;
                                    break;
                                case Keys.Down:
                                    if (gameObjects.Player1.Jet.Pos_y + gameObjects.Player1.Jet.Height < pictureBox1.Height)
                                        gameObjects.Player1.Jet.Pos_y += gameObjects.Player1.Jet.Speed;
                                    break;
                                case Keys.Left:
                                    if (gameObjects.Player1.Jet.Pos_x > pictureBox1.Width / 2 + gameObjects.Player1.Jet.Width + 2 * gameObjects.Player1.Jet.Cockpit_size)
                                        gameObjects.Player1.Jet.Pos_x -= gameObjects.Player1.Jet.Speed;
                                    break;
                                case Keys.Up:
                                    if (gameObjects.Player1.Jet.Pos_y > 0)
                                        gameObjects.Player1.Jet.Pos_y -= gameObjects.Player1.Jet.Speed;
                                    break;
                                case Keys.Return:
                                    if (gameObjects.Player1.Ammo != 0)
                                    {
                                        Bullet1 bullet = new Bullet1(gameObjects.Player1.Jet.Pos_x + gameObjects.Player1.Jet.Width + gameObjects.Player1.Jet.Cockpit_size, gameObjects.Player1.Jet.Pos_y + gameObjects.Player1.Jet.Height / 2);
                                        gameObjects.Player1.Bulletlist.Add(bullet);
                                        gameObjects.Player1.Ammo--;
                                    }
                                    break;
                            }
                        }
                        else
                        {
                            switch (e.KeyData)
                            {
                                case Keys.Right:
                                    if (gameObjects.Player2.Jet.Pos_x < pictureBox1.Width)
                                        gameObjects.Player2.Jet.Pos_x += gameObjects.Player2.Jet.Speed;
                                    break;
                                case Keys.Down:
                                    if (gameObjects.Player2.Jet.Pos_y + gameObjects.Player2.Jet.Height < pictureBox1.Height)
                                        gameObjects.Player2.Jet.Pos_y += gameObjects.Player2.Jet.Speed;
                                    break;
                                case Keys.Left:
                                    if (gameObjects.Player2.Jet.Pos_x > pictureBox1.Width / 2 + gameObjects.Player2.Jet.Width + 2 * gameObjects.Player2.Jet.Cockpit_size)
                                        gameObjects.Player2.Jet.Pos_x -= gameObjects.Player2.Jet.Speed;
                                    break;
                                case Keys.Up:
                                    if (gameObjects.Player2.Jet.Pos_y > 0)
                                        gameObjects.Player2.Jet.Pos_y -= gameObjects.Player2.Jet.Speed;
                                    break;
                                case Keys.Return:
                                    if (gameObjects.Player2.Ammo != 0)
                                    {
                                        gameObjects.Player2.Fired = true;
                                        gameObjects.Player2.Ammo--;
                                    }
                                    break;
                            }
                        }
                    }
                }
            }
        }

        private void timer1_Tick(object sender, EventArgs e)
        {
            progressBar1.Value = gameObjects.Player1.Ammo;
            progressBar2.Value = gameObjects.Player1.Health;
            progressBar3.Value = gameObjects.Player2.Ammo;
            progressBar4.Value = gameObjects.Player2.Health; 
            if (!localGame && !localPlayerIsHost)
            {
                if (gameObjects.ServerClosed)
                {
                    disconnect();
                    Close();
                }
            }
            else
            {
                if (GameOver.End == false)
                {
                    for (int i = 0; i < gameObjects.Player1.Bulletlist.Count; i++)
                    {
                        Bullet b = gameObjects.Player1.Bulletlist[i];
                        b.Update(g, gameObjects);
                    }
                    for (int i = 0; i < gameObjects.Player2.Bulletlist.Count; i++)
                    {
                        Bullet b = gameObjects.Player2.Bulletlist[i];
                        b.Update(g, gameObjects);
                    }
                    for (int i = 0; i < gameObjects.AstroidList.Count; i++)
                        gameObjects.AstroidList[i].Update(g, gameObjects);
                    if (timeElapsed % Astroid.Timeout == 0)
                    {
                        Astroid astroid = new Astroid(Width, Height);
                        gameObjects.AstroidList.Add(astroid);
                    }
                    if (gameObjects.Player2.Fired == true)
                    {
                        Bullet2 bullet = new Bullet2(gameObjects.Player2.Jet.Pos_x - gameObjects.Player2.Jet.Width - gameObjects.Player2.Jet.Cockpit_size, gameObjects.Player2.Jet.Pos_y + gameObjects.Player2.Jet.Height / 2);
                        gameObjects.Player2.Bulletlist.Add(bullet);
                        gameObjects.Player2.Fired = false;
                    }
                    timeElapsed++;
                }
                else { stillOpen = false; timer1.Enabled = false; }
            }
        }

        private void Form1_Load(object sender, EventArgs e)
        {

        }

        private void Form1_FormClosing(object sender, FormClosingEventArgs e)
        {
            stillOpen = false;
            if (thread != null)
                thread.Abort();
            if(!localGame && localPlayerIsHost) stopServer();
        }


        private void hostNetworkGame()
        {
            serverChan = new TcpChannel(8085);
            ChannelServices.RegisterChannel(serverChan, false);
            gameObjects = new ClsGameObjects(this.Width, this.Height);
            RemotingServices.Marshal(gameObjects, "GameObjects");
            localGame = false;
            localPlayerIsHost = true;
            while (true)
            {
                if (gameObjects.Connected == true)
                {
                    startGame();
                    break;
                }
            }
       }

        private void stopServer()
        {
            gameObjects.ServerClosed = true;
            Thread.Sleep(5);
            ChannelServices.UnregisterChannel(serverChan);
            serverChan = null;
        }

        private void joinNetworkGame(string IPAdress)
        {
            clientChan = new TcpChannel();
            ChannelServices.RegisterChannel(clientChan, false);
            gameObjects = (ClsGameObjects)Activator.GetObject(typeof(ClsGameObjects), "tcp://"+IPAdress+":8085/GameObjects");
            localGame = false;
            localPlayerIsHost = false;
            gameObjects.Connected = true;
            startGame();
        }
        
        private void disconnect()
        {
            ChannelServices.UnregisterChannel(clientChan);
            clientChan = null; 
        }

        private void hostToolStripMenuItem_Click_1(object sender, EventArgs e)
        {
            hostNetworkGame();
        }

        private void joinToolStripMenuItem_Click_1(object sender, EventArgs e)
        {
            VerbindungsDialog vd = new VerbindungsDialog();
            if (vd.ShowDialog() == DialogResult.OK)
                try
                {
                    if (vd.Controls[3].Text == "...")
                        joinNetworkGame("127.0.0.1");
                    else
                        joinNetworkGame(vd.Controls[3].Text);
                }
                catch { MessageBox.Show("Could not connect to server!"); }
        }

        private void LocalGameToolStripMenuItem_Click(object sender, EventArgs e)
        {
            localGame = true;
            gameObjects = new ClsGameObjects(this.Width, this.Height);
            startGame();
        }



    }


}



