var pjow = {
	height: 0,
	width: 0,
	tw: 0,
	th: 48,
	jc: '',
	jthumb: '',
	jshow: '',
	jmain: '',
	jtitle: '',
	jbuttons: '',
	diff: 0,
	d: 0,
	index: 0,
	count: 0,
	playMode: false,
	cache: [],
	imgs: [],
	stillLoad: 0
};

jQuery(document).ready(function() {
	pjow.jc = jQuery('#jowcase');
	pjow.height = parseInt(pjow.jc.attr('height'));
	pjow.width = parseInt(pjow.jc.attr('width'));
	pjow.jc.css({ width: pjow.width, height: pjow.height + pjow.th + 3 });

	pjow.jc.children().each(function(i,v) {
		var geg = {
			thumb: jQuery(v).attr('small'),
			big: jQuery(v).attr('big'),
			show: jQuery(v).attr('src'),
			title: jQuery(v).attr('title'),
			description: jQuery(v).attr('alt'),
			index: i,
			selected: i == 0
		};
		
		if(geg.thumb)
		    preLoadImages(geg.thumb);
		
		preLoadImages(geg.show);
		pjow.imgs.push(geg);
        jQuery(v).remove();
	});

	pjow.count = pjow.imgs.length;
	pjow.jc.css('background' ,'#FFF url("img/load.gif") no-repeat center center');
});

function initPhotojow() {
    pjow.jc.css('background', '#FFF');
	var t = '<div id="jowtitle" style="top: -' + (pjow.th + 3 + 50) + 'px"></div>';
	jQuery('<div id="jowmain"></div>').css({height: pjow.height, width: pjow.width}).html(t).appendTo(pjow.jc);
	jQuery('<div id="jowshow"></div>').css({height: pjow.th + 3, width: pjow.width}).appendTo(pjow.jc);
	jQuery('<div id="jowbuttons"></div>').css({top: - pjow.height - pjow.th - 23}).appendTo(pjow.jc).hide();
	pjow.jmain = jQuery('#jowmain');
	pjow.jshow = jQuery('#jowshow');
	pjow.jtitle = jQuery('#jowtitle');
	pjow.jbuttons = jQuery('#jowbuttons');
	pjow.jbuttons.append('<a onclick="next(-1);"><img src="img/rewind.png" /></a>').append('<span id="jowpp"></span>')
	.append('<a onclick="next(1);"><img src="img/forward.png" /></a>').append('<span id="jowsh"></span>');
	var j = 0;
	
	jQuery.each(pjow.imgs, function(i,v) {
		var tn = pjow.cache[j++];
		
		if(v.thumb)
		    ++j;
		    
		jQuery('<div class="thumb"></div>').append(tn).appendTo(pjow.jshow)
		.click(function() {
			pjow.jshow.stop();
			pjow.d = parseInt(pjow.jshow.css('left').replace('px',''));
			var data = jQuery(this).data();
			pjow.index = data.index;
			jQuery(this).parent().children('div').removeClass('selected').end().end().addClass('selected');
			jQuery('#preview').fadeOut('fast', function() { jQuery(this).remove(); });
			jQuery('<img id="preview" src="' + data.show + '" alt="' + data.title + '" />')
			.css({ height: pjow.height, width: pjow.width }).prependTo(pjow.jmain).hide().delay(200).fadeIn('slow')
			.click(function() {
				if(data.big)
				{
					var t = jQuery('<a href="' + data.big + '" id="hyperlink"></a>').hide().appendTo('body');
					var link = document.getElementById('hyperlink').href;
					t.remove();
					
					if(window.Shadowbox)
						Shadowbox.open({ content: link, player: 'img' });
					else
						window.open(link);
				}
			});
			pjow.jtitle.html(data.title ? '<strong>' + data.title + '</strong></br>' + data.description : data.description);
			var l = parseInt(pjow.jshow.css('left').replace('px',''));
			var pos = jQuery(this).offset().left - pjow.jshow.offset().left + l;
			l = pos + jQuery(this).width() - pjow.width;
			pos = (-pos);
			
			if(pos > 0)
			    pjow.jshow.animate({ left: '+=' + pos }, 200);
			else if(l > 0)
			    pjow.jshow.animate({ left: '-=' + l }, 200);
		}).hover(function() {
			pjow.jthumb.removeClass('hover');
			jQuery(this).addClass('hover');
		}, function() {
		    jQuery(this).removeClass('hover');
		}).data(v);
	});
	pjow.jc.hover(function() {
	    pjow.jbuttons.slideDown('slow');
	}, function() { 
	    pjow.jbuttons.slideUp('slow');
    });
	pjow.jthumb = jQuery('.thumb');
	
	pjow.jthumb.each(function(j,w) {
	    pjow.tw += parseInt(jQuery(w).width());
	});
	
	pjow.jshow.width(pjow.tw);
	pjow.diff = pjow.width - pjow.tw;
	
	pjow.jshow.mousemove(function(e) {
		var l = e.pageX - this.offsetLeft + parseInt(pjow.jshow.css('left').replace('px',''));
		var k = l > 2 * pjow.width / 3 ? pjow.diff : 0;
		
		if(l > pjow.width / 3 && k == 0)
		    pjow.jshow.stop();
		else if(k != pjow.d)
		    animate(k);
	}).hover(function(e) {
		var l = e.pageX - this.offsetLeft + parseInt(pjow.jshow.css('left').replace('px',''));
		var pos = l > 2 * pjow.width / 3 ? pjow.diff : 0;
		
		if(l < pjow.width / 3 || pos != 0)
		    animate(pos);
	}, function () {
	    pjow.jshow.stop();
	});
	jQuery('.thumb:first').click();
	play();
	showTitle();
}

function play() {
	jQuery('#jowpp').html('<a onclick="pause();"><img src="img/pause.png" /></a>');
	pjow.playMode = true;
	loop(5000);
}

function loop(t) {
	setTimeout(function() { if(pjow.playMode) { next(1); loop(t); } }, t);
}

function pause() {
	jQuery('#jowpp').html('<a onclick="play();"><img src="img/play.png" /></a>');
	pjow.playMode = false;
}

function hideTitle() {
	jQuery('#jowsh').html('<a onclick="showTitle();"><img src="img/show.png" /></a>');
	pjow.jtitle.fadeOut('slow');
}

function showTitle() {
	jQuery('#jowsh').html('<a onclick="hideTitle();"><img src="img/hide.png" /></a>');
	pjow.jtitle.fadeIn('slow');
}

function next(u) {
	var i = (pjow.index + u + pjow.count) % pjow.count;
	jQuery('.thumb:eq(' + i + ')').click();
}

function animate(pos) {
	pjow.d = pos;
	pjow.jshow.stop();
	pjow.jshow.animate({ left: pos }, 2000);
}

function preLoadImages() {
    for (var i = arguments.length; i--;) {
        pjow.stillLoad++;
		var cacheImage = jQuery('<img />');
		cacheImage.attr('src', arguments[i]).load(function() {
		    pjow.stillLoad--;
		    
		    if(!pjow.stillLoad)
		        initPhotojow();
		});
		pjow.cache.push(cacheImage);
    }
}